			/* @(#) terminate.c */

/** File: terminate.c  - Copyright (C) 1998 Nathan Benson
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **/

#include <utmp.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include "../include/ku.h"

int	count=0;
int	header=TRUE;
char	ans[256];
char	*userHost;
char	*kernInfo;

int	TermUser(struct utmp *u,
		struct CLopt opt,
		struct CLargs args,
		char dev[24])
{
	if (opt.opt_p)
	{
		if (!u->ut_host[0])
			userHost="localhost";
		else
			userHost=u->ut_host;

		while (TRUE)
		{
			printf("terminate: %s (%s:%s) ", u->ut_user, u->ut_line,userHost);
			gets(ans);

			if (strncasecmp(ans,"y",1)==0)
			{
				/* prints kill message */
			        if (opt.opt_m)
        			{
        			        KillMessage(u,opt,args,dev);
        			}
 	
				/* does the killing */
				if (kill(u->ut_pid,SIGKILL)!=0)
				{
					kill(u->ut_pid,15);
					kill(u->ut_pid,SIGKILL);
				}
				PrintVerbose(u,opt,args,dev);
				return(0);
			}
			else if (strncmp(ans,"?",1)==0)
			{	
				PrintVerbose(u,opt,args,dev);
				continue;
			}
			else
			{
				return(0);
			}
		}
	}

        if (opt.opt_m)
        {
                KillMessage(u,opt,args,dev);
        }
 
	/* does the killing */
	if (kill(u->ut_pid,SIGKILL)!=0)
	{
		kill(u->ut_pid,15);
		kill(u->ut_pid,SIGKILL);
	}
	PrintVerbose(u,opt,args,dev);
	return(0);
}
/* EOF */
