			/* @(#) message.c */

/** File: message.c  - Copyright (C) 1998 Nathan Benson
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **/

#include <pwd.h>
#include <grp.h>
#include <time.h>
#include <utmp.h>
#include <stdio.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "../include/ku.h"

char	printHost[50];
char	*ctime();
char	*user;
char	*str;
char 	*s;

int	i;
int	count;
int	cstr=0;
int	heading=TRUE;
time_t	lastChange;

struct	stat	stats;
struct	group	*grp;
struct	passwd	*gecos;
struct	passwd	*p;

char	KillMessage(struct utmp *u,
		    struct CLopt opt,
		    struct CLargs args,
		    char dev[24])
{
	FILE	*fopen(),*usertty,*hostname;
	usertty=fopen(dev,"a");
	hostname=fopen("/etc/HOSTNAME","r");

	if (opt.opt_msg==TRUE)
		s=args.tmp_arg;
	else
		s=DKILL;

	/* the user name we are talking to */
	user=u->ut_user;

	if (hostname)
	{
		fgets(printHost,50,hostname);
		str=strtok(printHost,".");
		fprintf(usertty,"\n\nYou were killed by: %s@%s\n\n",getlogin(),str);
	}
	else
	{
		fprintf(usertty,"\n\nYou were killed by: %s@localhost\n\n",getlogin());
	}
	fclose(hostname);

	/* checks for errors in opening the tty
	 * and checks to see if it was an Xterm
	 * if it's an Xterm why waste the resources
	 * printing to the terminal if they wont see
	 * it. (=
	 */
	if ((usertty!=NULL)&&(!opt.opt_x))
	{
		count=(strlen(args.m_arg) - 1);  /* this should be a null char */
                for (i = 0; i <= count; i++)
                { 
	                switch (s[i])
                        {
                                case '%':
				{
					switch (s[++i])
					{
						/* parse %l (Login name) */
						case 'l':
						{
							fprintf(usertty,"%s",user);
							continue;
						}

						/* parse %r (Real Name) */
						case 'r':
						{
							/* put it here so
							 * we only have to
							 * parse the info
							 * if %r was found
							 */
							gecos=getpwnam(u->ut_user);

							if (strtok(gecos->pw_gecos, ",,,")!=NULL)
							{
								fprintf(usertty,"%s",strtok(gecos->pw_gecos,",,,"));
								continue;
							}
							else
							{
								fprintf(usertty,"%s",gecos->pw_gecos);
								continue;
							}
							continue;
						}

						/* parse %s (shell) */
						case 's':
						{
							gecos=getpwnam(u->ut_user);
							fprintf(usertty,"%s",gecos->pw_shell);
							continue;
						}

						/* parse %h (home directory) */
						case 'h':
						{
							gecos=getpwnam(u->ut_user);
							fprintf(usertty,"%s",gecos->pw_dir);
							continue;
						}

						/* parse %g (GID) */
						case 'g':
						{
							gecos=getpwnam(u->ut_user);
							fprintf(usertty,"%d",gecos->pw_gid);
							continue;
						}

						/* parse %g (Group name) */
						case 'G':
						{
							gecos=getpwnam(u->ut_user);

							grp=getgrgid(gecos->pw_gid);
							fprintf(usertty,"%s",grp->gr_name);

							continue;
						}

						/* parse %u (UID) */
						case 'u':
						{
							gecos=getpwnam(u->ut_user);
							fprintf(usertty,"%d",gecos->pw_uid);
							continue;
						}

						case 'H':
						{
							if (!u->ut_host[0])
								fprintf(usertty, "%s","localhost");
							else
								fprintf(usertty, "%s", u->ut_host);
							
							continue;
						}

						case 't':
						{
							fprintf(usertty, "%s", u->ut_line);
							continue;
						}

						case 'p':
						{
							fprintf(usertty, "%d", u->ut_pid);
							continue;
						}
						case 'V':
						{
							fprintf(usertty,"%s",VERSION);
							continue;
						}

						default:
						{
							fprintf(usertty,"%c",s[i]);
							continue;
						}
					}
				}
				default:
					fprintf(usertty,"%c",s[i]);
					continue;
			}
		}
		fprintf(usertty,"\n\n");
		fclose(usertty);
		count=0;
		s=NULL;
		i=0;

		return(0);
	}
	return(1);
}
/*
const	char	*MessageIdleTime(time_t when)
{
	static	time_t	now = 0;
	static	char	idle[20];
	time_t	secondsIdle;

	if (now == 0)
	{
		time(&now);
	}

	secondsIdle = now - when;

	if (secondsIdle < 60)
	{
		sprintf(idle,"%2d seconds",secondsIdle);
		return((const char *) idle);
	}

	if (secondsIdle < (24 * 60 * 60))
	{
		sprintf (idle, "%2d hours %2d minutes",
		(int) (secondsIdle / (60 * 60)),
		(int) ((secondsIdle % (60 * 60)) / 60));

		return((const char *) idle);
	}
	return(" days ");
}
*/
/* EOF */
