			/* @(#) idle.c */

/** File: idle.c - Copyright (C) 1998 Nathan Benson
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **/


#include <stdio.h>
#include <time.h>

char	*ctime();

const	char	*idleTime(time_t when)
{
	/* set up some variables */

	static	time_t	now = 0;
	static	char	idle[10];
	time_t	secondsIdle;

	if (now == 0)
	{
		time(&now);
	}

	/* get the differance between the two */
	secondsIdle = now - when;
	if (secondsIdle < 60)        /* One minute. */
	{
		return("  .  ");
	}

	if (secondsIdle < (24 * 60 * 60)) /* One day. */
	{
		sprintf (idle, "%02d:%02d",
		(int) (secondsIdle / (60 * 60)),
		(int) ((secondsIdle % (60 * 60)) / 60));

		return((const char *) idle);
	}
	return(" days ");
}
/* EOF */
