
/* defines */

#ifndef TRUE
	#define TRUE 1
	#define FALSE 0
#endif

#ifndef S_IGRWP
	#define S_IGRWP 00020
#endif

#define VERSION "killuser version 1.0.0"
#define DKILL	"%l (%t:%H) was terminated by %V"
#undef HEADER

/* prototypes */

int		TermUser();			/* terminates the user */
int		CheckSanity();			/* check for a goofy command line */
int		PrintVerbose();			/* tells you who was terminated */
int		Process_Type();			/* make sure it's a valid login */
int		ProveIdleTime();		/* gets users idle times */
int		ProveCommandLine();		/* prove command line options */

const   char	*idleTime();			/* gets users idle times */
char		KillMessage();			/* printing kill messages */
char		usageMoron(char *argv[]);	/* help please */

/* structures */

struct	CLopt			/* command line options */
{
	int	opt_a;		/* --all	*/
	int	opt_b;		/* --beep	*/
	int	opt_g;		/* --group	*/
	int	opt_G;		/* --group	*/
	int	opt_h;		/* --header	*/
	int	opt_H;		/* --help	*/
	int	opt_i;		/* --idle	*/
	int	opt_s;		/* --string	*/
	int	opt_m;		/* --message	*/
	int	opt_p;		/* --prompt	*/
	int	opt_t;		/* --telnet	*/
	int	opt_T;		/* --tty	*/
	int	opt_u;		/* --user	*/
	int	opt_x;		/* --xterm	*/
	int	opt_v;		/* --verbose	*/
	int	opt_V;		/* --version	*/

	int	opt_msg;	/* use DKILL?	*/
};

struct	CLargs			/* command line arguments */
{
	int	i_arg;		/* --idle arg	*/
	int	G_arg;		/* --idle arg	*/
	char	*g_arg;		/* --group arg	*/
	char	*m_arg;		/* --message arg*/
	char	*T_arg;		/* --tty arg	*/
	char	*s_arg;		/* --string arg	*/
	char	*u_arg;		/* --user arg	*/
	char	str[256];	/* used for storing stuph */
	char	tmp_arg[256];	/* used for storing other args */
};

struct  passwd  *p;             /* checking UID's and user names */
struct  utmp    *u;             /* pointer to utmp file entry */
struct  CLopt   opt;            /* command line options */
struct  CLargs  args;           /* command line arguments */
struct  utmp    *getutent();    /* returns next utmp file entry */
