#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <malloc.h>
#include <signal.h>
#include <stdlib.h>
#include <ctype.h>
#include <syslog.h>

#include <utmp.h>
#define STRUCT_UTMP struct utmp
#define UT_TIME_MEMBER(UT_PTR) ((UT_PTR)->ut_time)

#include "config.h"

static STRUCT_UTMP *utmp_contents;

int numlogin(char*,char*,char *);

int main (int argc, char **argv)
{ 
    FILE *statf = stdin;
    FILE *conf_file;
    char filename[100]; 
    char username[50];
    char conf_user[50];
    int  conf_login;
    int maxlogin = DEFAULT_MAXLOGIN;
    int nlogins = 0;
    char ttys[2048] = ""; /* adjust if you think this is too big 
                          for saving ttys of user */
    
    if (argc != 3) {
      fprintf(stderr,"usage : %s <fullttyname> <pppd pid>\n",argv[0]);
      exit(1);
    } 
    
    openlog ("ppplogin",LOG_PID, LOG_LOCAL2);
        
    sprintf(filename,"/proc/%s/stat",argv[2]);
    while (statf != NULL) 
    {
        sleep(15); /* give time for pppd */
    
        statf = fopen(filename,"r");
        if (statf != NULL) /* check if pppd is still up */
        { 
          fclose(statf);

          nlogins = numlogin(argv[1],username,ttys);

          if (nlogins == 0) /* not yet authenticted */
             continue;
          
          conf_file = fopen(PPPLOGIN_CONF,"r");
          if (conf_file != NULL)
          {
             fscanf(conf_file,"%s %d",conf_user, &conf_login);
	     do {

		if (strcmp(conf_user,username)==0) 
		{
		   maxlogin = conf_login;
		   break;
		}   
		fscanf(conf_file,"%s %d",conf_user, &conf_login);

	     } while (!feof(conf_file));
	     fclose(conf_file);
	  }   
          if (nlogins > maxlogin) {  
             if (nlogins > 1)
                syslog(LOG_INFO, 
                       "%s rejected on %s, already on %s %d out of %d allowed",
                       username,argv[1],ttys,nlogins,maxlogin);
             else
                syslog(LOG_INFO, 
                       "%s rejected on %s, %d out of %d allowed",
                       username,argv[1],nlogins,maxlogin);
                       
             kill(atoi(argv[2]),SIGTERM); /* more than one connection */
             exit(1);
          } 
          else
          {
             if (nlogins > 1)
                 syslog(LOG_INFO, 
                       "%s login ok on %s, also on %s %d out of %d allowed",
                        username,argv[1],ttys,nlogins,maxlogin);
             else
                 syslog(LOG_INFO, 
                       "%s login ok on %s, %d out of %d allowed",
                        username,argv[1],nlogins,maxlogin);
                           
             exit(0);  /* login is ok */    
          }  
        }
    }
    syslog(LOG_ERR, "pppd with pid %s terminated for some reason",argv[2]);   
    return 1; /* pppd terminated for some reason */
}




/* Copy UT->ut_name into storage obtained from malloc.  Then remove any
   trailing spaces from the copy, NUL terminate it, and return the copy.  */

static char *
extract_trimmed_name (const STRUCT_UTMP *ut)
{
  char *p, *trimmed_name;

  trimmed_name = (char *) malloc (sizeof (ut->ut_name) + 1);
  strncpy (trimmed_name, ut->ut_name, sizeof (ut->ut_name));
  /* Append a trailing space character.  Some systems pad names shorter than
     the maximum with spaces, others pad with NULs.  Remove any spaces.  */
  trimmed_name[sizeof (ut->ut_name)] = ' ';
  p = strchr (trimmed_name, ' ');
  if (p != NULL)
    *p = '\0';
  return trimmed_name;
}

char *getline(STRUCT_UTMP *this)
{
#define DEV_DIR_WITH_TRAILING_SLASH "/dev/"
#define DEV_DIR_LEN (sizeof (DEV_DIR_WITH_TRAILING_SLASH) - 1)

  static char line[sizeof (this->ut_line) + DEV_DIR_LEN + 1];
  /* Copy ut_line into LINE, prepending `/dev/' if ut_line is not
     already an absolute pathname.  Some system may put the full,
     absolute pathname in ut_line.  */
  if (this->ut_line[0] == '/')
    {
      strncpy (line, this->ut_line, sizeof (this->ut_line));
      line[sizeof (this->ut_line)] = '\0';
    }
  else
    {
      strcpy (line, DEV_DIR_WITH_TRAILING_SLASH);
      strncpy (line + DEV_DIR_LEN, this->ut_line, sizeof (this->ut_line));
      line[DEV_DIR_LEN + sizeof (this->ut_line)] = '\0';
    }
  
   return line;
   
}


STRUCT_UTMP *useronline (char *line,int n)
{
  STRUCT_UTMP *this = utmp_contents;
  
  while (n--)
    {
      if (this->ut_name[0] && this->ut_type == USER_PROCESS && !strcmp(line,getline(this)))
          return this;
      this++;
    }
  return NULL;
}




static int
read_utmp (char *filename)
{
  FILE *utmp;
  struct stat file_stats;
  size_t n_read;
  size_t size;

  utmp = fopen (filename, "r");
  if (utmp == NULL)
    fprintf(stderr,"error openning %s", filename);

  fstat (fileno (utmp), &file_stats);
  size = file_stats.st_size;
  if (size > 0)
    utmp_contents = (STRUCT_UTMP *) malloc (size);
  else
    {
      fclose (utmp);
      return 0;
    }

  /* Use < instead of != in case the utmp just grew.  */
  n_read = fread (utmp_contents, 1, size, utmp);
  if (ferror (utmp) || fclose (utmp) == EOF
      || n_read < size)
    fprintf(stderr,"error %d %s", errno, filename);

  return size / sizeof (STRUCT_UTMP);
}

/* returns the number of login 
copies username on who*/

int numlogin (char *line, char *who, char *ttys)
{
  int n,occurrence = 0;
  int ttyprefixlen;
  char *username,*t;
  STRUCT_UTMP *this; 
  STRUCT_UTMP *user;
  char *currentline = "";

  if (!line || !(*line)) return 0;
    
  n = read_utmp(UTMP_FILE);
  this = utmp_contents;
  
  user = useronline(line,n);
  
  if (!user) return 0;
  
  username = extract_trimmed_name(user);
  strcpy(who,username);
  ttyprefixlen = strlen(line);
  while (ttyprefixlen && isdigit(line[ttyprefixlen-1])) 
     ttyprefixlen--;
  while (n--) {
    if (this->ut_name[0] && this->ut_type == USER_PROCESS){
      t = extract_trimmed_name(this);
      currentline = getline(this);
      if ( !strcmp(username,t)  && !strncmp(line,currentline,ttyprefixlen)) {
          occurrence++;   
          if (strcmp(currentline,line)) 
          {
            strcat(ttys,currentline+4);
            strcat(ttys,", ");  
          }  
      }    
      free(t);    
    }
    this++;
  }
  free(username);
  free(utmp_contents);
  return occurrence;
}  


